set echo ON;
spool /datos/p06b/log/salida_20170928.log;

UPDATE P06B24T00_ORGANOSDIREXP C
SET C.P06B24_TIPO = C.P06B24_TIPO + 10
WHERE (C.P06B24_NUMEXP, C.P06B24_IDENTIFICADOR, C.P06B24_IDCARGO, C.P06B24_TIPO) IN 
(
SELECT P06B24_NUMEXP, P06B24_IDENTIFICADOR, P06B24_IDCARGO, P06B24_TIPO FROM P06B24T00_ORGANOSDIREXP B,
(SELECT P06B24_NUMEXP AS NUMEXP, P06B24_IDENTIFICADOR AS IDEN, P06B24_IDCARGO AS CARGO, MIN(A.P06B24_TIPO) AS MINIMO
FROM P06B24T00_ORGANOSDIREXP A
WHERE A.P06B24_TIPO IN (1,2,3)
GROUP BY A.P06B24_NUMEXP, A.P06B24_IDENTIFICADOR, A.P06B24_IDCARGO
HAVING COUNT(*) > 1
ORDER BY 1)
WHERE B.P06B24_NUMEXP = NUMEXP AND
      B.P06B24_IDENTIFICADOR = IDEN AND
      B.P06B24_IDCARGO = CARGO AND
      B.P06B24_TIPO > MINIMO AND
      B.P06B24_TIPO IN (1,2,3)
);

UPDATE P06B24T00_ORGANOSDIREXP
SET P06B24_TIPO = 1
WHERE P06B24_TIPO IN (2,3);


ALTER TABLE P06B64T00_ATENDERPETICION ADD(
	P06B64_AP_PROCEDIMIENTO VARCHAR2(10)
);

COMMENT ON COLUMN P06B64T00_ATENDERPETICION.P06B64_AP_PROCEDIMIENTO IS 'Procedimiento: Alta, Modificacion y Cancelacion (Valores definidos en properties)';


ALTER TABLE P06B20T00_CORREDORES ADD (
P06B20_TIPOATENCIONCLIENTE VARCHAR2(1) DEFAULT '5');

UPDATE P06B20T00_CORREDORES SET
P06B20_TIPOATENCIONCLIENTE = '3'
WHERE P06B20_NUMEXP IN
(select distinct P06B20_NUMEXP from P06B20T00_CORREDORES, P06B26T00_ATENCLIENTE
where P06B20_NUMEXP =  P06B26_NUMEXP
union
select distinct P06B20_NUMEXP from P06B20T00_CORREDORES, P06B29T00_DEFECLIENTE
where P06B20_NUMEXP =  P06B29_NUMEXP);

COMMENT ON COLUMN P06B20T00_CORREDORES.P06B20_TIPOATENCIONCLIENTE IS 'Tipo Atencin Cliente: No procede(4), Pendiente informar(5), Adherido al CV(1), Adherido al CG(2), Cuenta con servicio(3)';



ALTER TABLE P06B70T00_CORREDORES ADD (
P06B70_CO_TIPOATENCIONCLIENTE VARCHAR2(1) DEFAULT '5');

COMMENT ON COLUMN P06B70T00_CORREDORES.P06B70_CO_TIPOATENCIONCLIENTE IS 'Tipo Atencin Cliente: No procede(4), Pendiente informar(5), Adherido al CV(1), Adherido al CG(2), Cuenta con servicio(3)';



ALTER TABLE P06B26T00_ATENCLIENTE ADD (
P06B26_TIPOATENCIONCLIENTE VARCHAR2(1) DEFAULT '3');

COMMENT ON COLUMN P06B26T00_ATENCLIENTE.P06B26_TIPOATENCIONCLIENTE IS 'Tipo Atencin Cliente: Adherido al CV(1), Adherido al CG(2), Cuenta con servicio(3)';



ALTER TABLE P06B29T00_DEFECLIENTE ADD (
P06B29_TIPOATENCIONCLIENTE VARCHAR2(1) DEFAULT '3');

COMMENT ON COLUMN P06B29T00_DEFECLIENTE.P06B29_TIPOATENCIONCLIENTE IS 'Tipo Atencin Cliente: Adherido al CV(1), Adherido al CG(2), Cuenta con servicio(3)';


Insert into P06B26T00_ATENCLIENTE (P06B26_NUMEXP,P06B26_IDENTIFICADOR,P06B26_TIPO,P06B26_CLASE,P06B26_RAZSOC,P06B26_NOMBRE,P06B26_APE1,P06B26_APE2,P06B26_DOMICI,P06B26_CODMUN,P06B26_LOCALI,P06B26_CODPRO,P06B26_CODPST,P06B26_TIPOATENCIONCLIENTE) values ('CV','99999999R','F','I',null,null,null,null,null,null,null,null,null,'1');
Insert into P06B26T00_ATENCLIENTE (P06B26_NUMEXP,P06B26_IDENTIFICADOR,P06B26_TIPO,P06B26_CLASE,P06B26_RAZSOC,P06B26_NOMBRE,P06B26_APE1,P06B26_APE2,P06B26_DOMICI,P06B26_CODMUN,P06B26_LOCALI,P06B26_CODPRO,P06B26_CODPST,P06B26_TIPOATENCIONCLIENTE) values ('CG','99999999R','F','I',null,null,null,null,null,null,null,null,null,'2');

Insert into P06B29T00_DEFECLIENTE (P06B29_NUMEXP,P06B29_IDENTIFICADOR,P06B29_TIPO,P06B29_RAZSOC,P06B29_NOMBRE,P06B29_APE1,P06B29_APE2,P06B29_DOMICI,P06B29_CODMUN,P06B29_LOCALI,P06B29_CODPRO,P06B29_CODPST,P06B29_TELEFOT,P06B29_TELEFOM,P06B29_TELEFOC,P06B29_FAX1,P06B29_FAX2,P06B29_MAIL,P06B29_WEB,P06B29_TIPOATENCIONCLIENTE) values ('CV','99999999R','F',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,'1');
Insert into P06B29T00_DEFECLIENTE (P06B29_NUMEXP,P06B29_IDENTIFICADOR,P06B29_TIPO,P06B29_RAZSOC,P06B29_NOMBRE,P06B29_APE1,P06B29_APE2,P06B29_DOMICI,P06B29_CODMUN,P06B29_LOCALI,P06B29_CODPRO,P06B29_CODPST,P06B29_TELEFOT,P06B29_TELEFOM,P06B29_TELEFOC,P06B29_FAX1,P06B29_FAX2,P06B29_MAIL,P06B29_WEB,P06B29_TIPOATENCIONCLIENTE) values ('CG','99999999R','F',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,'2');

COMMIT;

exit;
